---
title: Create billing profile · Cloudflare Billing docs
description: A primary payment method is required to process payment for
  Cloudflare products and services. We value your confidentiality and privacy -
  Cloudflare does not have access to your bank, credit card, pin, or PayPal
  account password details.
lastUpdated: 2025-09-03T18:47:47.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/billing/create-billing-profile/
  md: https://developers.cloudflare.com/billing/create-billing-profile/index.md
---

## Add a primary payment method

A primary payment method is required to process payment for Cloudflare products and services. We value your confidentiality and privacy - Cloudflare does not have access to your bank, credit card, pin, or PayPal account password details.

Note

Customers on an [Enterprise plan](https://www.cloudflare.com/plans/enterprise/contact/) have [additional payment options](https://developers.cloudflare.com/billing/create-billing-profile/#payment-options) such as wire and ACH, as well as yearly or quarterly billing.

1. In the Cloudflare dashboard, go to the **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. Select **Payment**. If no payment method is on file, the **Payment methods** dialog opens automatically.

3. Select **Manage** next to your current payment method. The **Manage payment methods** dialog opens.

4. Enter the required information based on the payment options below: **Credit card**:

   1. Enter the required information under the **Credit Card Details** form.
   2. If applicable, add your business information to your invoice, including your **Company** and **VAT/GST Number**.

   **PayPal** (Your credit card will be charged if you have insufficient funds in your PayPal account):

   1. Select the **PayPal**.
   2. Follow the online instructions until PayPal returns you to the Cloudflare **Payment Method** to continue your set-up.
   3. Verify your **PayPal username** now appears next to the PayPal logo.
   4. Add your account contact information as well as **Company** and **VAT/GST Number**, if applicable.

Note

Because some countries tax goods and services on personal accounts, you may be asked to indicate whether your Cloudflare account is personal or business to determine tax eligibility.

1. Review the payment method and contact information to ensure it is accurate.
2. To finish, select **Confirm**.
3. Ensure your new payment method appears in the **Payment Method** section.

Enterprise customers must email <ar@cloudflare.com> with the last four digits of the credit card and its expiration date.

## Add a backup payment method

Optionally, add a backup payment method to use if the primary payment method fails.

Note

You may receive the error message "Cannot add more than two payment methods." when trying to add additional methods.

If you are unable to add or edit a payment method, [delete a payment method](https://developers.cloudflare.com/billing/update-billing-info/#delete-a-payment-method) and try again.

1. In the Cloudflare dashboard, go to the **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. Select **Payment**.

3. From **Payment methods**, select **Manage**.

4. From **Backup**, select **Add** to enter a backup payment method.

5. Enter the required information based on your preferred payment method (credit card or PayPal) and select **Confirm**.

6. To make the backup payment method the primary method, select **Make primary payment method**.

## Payment options

Enterprise customers can submit payments via the following payment options:

### ACH

(preferred method)

* **Bank**: Citibank, One Penn's Way, New Castle, DE 19720 USA
* **Account name**: CLOUDFLARE INC
* **Account number**: 31460181
* **ABA/Routing number**: 031100209

### Wire transfer

* **Bank**: Citibank, One Penn's Way, New Castle, DE 19720 USA
* **Account name**: CLOUDFLARE INC
* **Account number**: 31460181
* **ABA/Routing number**: 031100209
* **SWIFT**: CITIUS33

### PayPal

Log in to your PayPal account and send your payment to <ar@cloudflare.com>. The payment must include the invoice number and customer name.

### International payments

* **Bank**: Citibank, One Penn's Way, New Castle, DE 19720 USA
* **Account name**: CLOUDFLARE INC
* **Account number**: 31460181
* **SWIFT**: CITIUS33

Note

US banks do not participate in International Bank Account Numbers (IBAN).
