---
title: Rewrite image paths with several URL segments · Cloudflare Rules docs
description: Create a URL rewrite rule (part of Transform Rules) to rewrite any
  requests for `/images/<FOLDER1>/<FOLDER2>/<FILENAME>` to `/img/<FILENAME>`.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: URL rewrite
source_url:
  html: https://developers.cloudflare.com/rules/transform/examples/rewrite-several-url-different-url/
  md: https://developers.cloudflare.com/rules/transform/examples/rewrite-several-url-different-url/index.md
---

To rewrite paths like `/images/<FOLDER1>/<FOLDER2>/<FILENAME>` — where `<FOLDER1>`, `<FOLDER2>`, and `<FILENAME>` can vary — to `/img/<FILENAME>`, create a URL rewrite rule with a dynamic rewrite of the path component:

Text in **Expression Editor**:

```txt
http.request.uri.path ~ "^/images/[^/]+/[^/]+/[^/]+$"
```

Text after **Path** > **Rewrite to** > *Dynamic*:

```txt
regex_replace(http.request.uri.path, "^/images/[^/]+/[^/]+/(.+)$", "/img/${1}")
```

For example, this rule would rewrite the `/images/nature/animals/tiger.png` path to `/img/tiger.png`.
